SELECT 
	SCHEMA_NAME(obj.schema_id) AS Esquema,
	obj.name AS Tabela, 
	col.name AS Coluna, 
	OBJECT_NAME(con.constid) AS Constante
INTO #Constraint
FROM 
	sys.objects obj INNER JOIN sys.columns col ON (obj.object_id=col.object_id) 
	INNER JOIN sys.sysconstraints con ON (obj.object_id=con.id and col.column_id=con.colid) 
WHERE 
	SCHEMA_NAME(obj.schema_id)='dbo' 
	AND obj.name='GLB_MOV_OP' 
	AND col.name='FLAG_ICMS_DEV_SN_CSOSN900';

DECLARE @Constraint NVARCHAR(500);
DECLARE @SQLString NVARCHAR(500);

IF EXISTS (SELECT * FROM #Constraint WHERE Tabela = 'GLB_MOV_OP' AND Coluna = 'FLAG_ICMS_DEV_SN_CSOSN900')
	SET @Constraint = (SELECT constante FROM #Constraint)
	SET @SQLString = 'ALTER TABLE [dbo].[GLB_MOV_OP] DROP CONSTRAINT  ' + @Constraint + ''
BEGIN
	EXECUTE sp_executesql @SQLString
	ALTER TABLE [dbo].[GLB_MOV_OP] ADD CONSTRAINT [DF_GLB_MOV_OP_FLAG_ICMS_DEV_SN_CSOSN900] DEFAULT 0 FOR [FLAG_ICMS_DEV_SN_CSOSN900]
END

DROP TABLE #Constraint;